import { getInvite } from "@/lib/store";
import InvitationClient from "./ui";

export default async function InvitePage({ params }) {
  const data = await getInvite(params.token);
  if (!data || !data.event || !data.guest) {
    return (
      <main className="min-h-screen grid place-items-center bg-neutral-950 text-white">
        <div className="max-w-md px-6 text-center">
          <div className="text-2xl font-semibold">Ftesa nuk u gjet</div>
          <div className="mt-2 text-sm text-neutral-300">
            Kontrollo linkun ose kontakto organizatorin.
          </div>
        </div>
      </main>
    );
  }

  return <InvitationClient token={params.token} initial={data} />;
}
